//**************************************************************************
//I2C߲
//**************************************************************************
#include "stm32f10x.h"
#include "i2c.h"
#include "delay.h"
#include "FT6336.h"

extern void delay_us(u32 nus);	 
extern void delay_ms(u16 nms);




/* 
**FT6236_Init
**
**ֵ
**ܣʼFT6236
*/  
  void FT6336_Init(void)
{
	u8 temp,KK;
	GPIO_InitTypeDef GPIO_InitStructure;					

	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOD|RCC_APB2Periph_GPIOE,ENABLE);

	//PD10:SDA
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10;	//PD10
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;		//
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;		//IOٶΪ50MHz	
	GPIO_Init(GPIOD,&GPIO_InitStructure);					//ʼӦGPIOE		
	GPIO_SetBits(GPIOD,GPIO_Pin_10);							//PD10 	
		/******  PD9:λSCL  ***************************************/	
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9;	//PE7	
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;		//
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;		//IOٶΪ50MHz	
	GPIO_Init(GPIOD,&GPIO_InitStructure);					//ʼӦGPIOE		
	GPIO_SetBits(GPIOD,GPIO_Pin_9);							//PE.7 
	/******  PE15:λRST  ***************************************/	
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_15;	//PE15
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;		//
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;		//IOٶΪ50MHz	
	GPIO_Init(GPIOE,&GPIO_InitStructure);					//ʼӦGPIOE		
	GPIO_SetBits(GPIOE,GPIO_Pin_15);							//PE.15 
	/**********************PE14жINT*********************/
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_14;				//PE14
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;//GPIO_Mode_IPU; 	//룬ͨ쳣
	GPIO_Init(GPIOE,&GPIO_InitStructure);	
	//VDD
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8;	//PD8	
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;		//
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;		//IOٶΪ50MHz	
	GPIO_Init(GPIOD,&GPIO_InitStructure);					//ʼӦGPIOE		
	GPIO_SetBits(GPIOD,GPIO_Pin_8);							//PD.8 
	//GND
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_13;	//PE13
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;		//
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;		//IOٶΪ50MHz	
	GPIO_Init(GPIOE,&GPIO_InitStructure);					//ʼӦGPIOE		
	GPIO_ResetBits(GPIOE,GPIO_Pin_13);							//PE.13 

	FT6336_RST_L();
	delay_ms(50);
	FT6336_RST_H();
	delay_ms(100);
	FT6336_SDA_H();
	delay_ms(10);
	FT6336_SCL_H();
	delay_ms(10);
	temp=0;
	FT6336_WR_Reg(FT_DEVIDE_MODE,&temp,1);	//ģʽ 
//	i2c_write_addr_byte(0x38,FT_DEVIDE_MODE,temp);
 	temp=22;								//Чֵ22ԽСԽ	
 	FT6336_WR_Reg(FT_ID_G_THGROUP,&temp,1);	//ôЧֵ
	FT6336_RD_Reg(FT_ID_G_THGROUP,&KK,1);
 	temp=14;								//ڣС1214
 	FT6336_WR_Reg(FT_ID_G_PERIODACTIVE,&temp,1); 
	FT6336_RD_Reg(FT_ID_G_PERIODACTIVE,&KK,1);
/******************************************************/
}




//-------------------------------ָƲ-----------------------
/****************************************************
*  
*      Ƭʼź
* ڲ 
* ز 
* ע 
*****************************************************/
void I2C_Start(void)
{
	SDA_OUT();     //sda
	FT6336_SDA_H();	  	  
	FT6336_SCL_H();
	delay_us(10);   //8ͨʱ,5us,16ͨʱ,½,Ҫ8us,Ϊ˱֤û10us
 	FT6336_SDA_L();//START:when i2c is high,DATA change form high to low 
	delay_us(5);
	FT6336_SCL_L();//ǯסI2Cߣ׼ͻ 
	delay_us(10);
}

/****************************************************
*  
*      Ƭֹͣź
* ڲ 
* ز 
* ע 
*****************************************************/
void I2C_End(void)
{
//	SDA_OUT();     		//sda
//	FT6336_SDA_L();		
//	delay_us(5);	
//	FT6336_SCL_H();		//SCLСߵƽ:0.6us		
////	delay_us(4);		//ֹͣźŵСʱ:0.6us
////	FT6336_SDA_L();	
//	delay_us(10);
//	FT6336_SDA_H();		//SCLߵƽڼ䣬SDAһرʾֹͣź
//	delay_us(5);		
	
	SDA_OUT();     		//sda
	FT6336_SCL_L();		//SCLСߵƽ:0.6us		
	FT6336_SDA_L();		
	delay_us(5);	
	FT6336_SCL_H();		//SCLСߵƽ:0.6us		
	delay_us(4);		//ֹͣźŵСʱ:0.6us
	FT6336_SDA_H();		//SCLߵƽڼ䣬SDAһرʾֹͣź
	delay_us(5);	
}


/****************************************************
*  
*      ƬӦź
* ڲ 
* ز 
* ע Ƭ1BݺһӦź
*****************************************************/
void FT6336_McuACK(void)							
{
	FT6336_SCL_L();
	SDA_OUT();     		//sda	
	FT6336_SDA_L();
	delay_us(5);																	
	FT6336_SCL_H();		//SCLСߵƽ:0.6us
	delay_us(10);
	FT6336_SCL_L();	//SCLС͵ƽ:1.2us
	delay_us(10);
	
	FT6336_SDA_H();
}


/****************************************************
*  
*      ƬͷӦź
* ڲ 
* ز 
* ע ƬֹͣǰһӦź
*****************************************************/
void FT6336_McuNACK(void)
{
	FT6336_SCL_L();
	SDA_OUT();     				//sda	
	FT6336_SDA_H();
	delay_us(5);																	
	FT6336_SCL_H();				//SCLСߵƽ:0.6us
	delay_us(10);
	FT6336_SCL_L();			//SCLС͵ƽ:1.2us
	delay_us(10);
}

/****************************************************
*  
*      ƬFT6236Ӧź
* ڲ 
* ز 1Ӧʧ
			 0Ӧɹ
* ע Ƭд1ַ/ݺ
			 ȫֱRevAckF:յFT6236Ӧźŵı־λ,Ϊ0ʾյ
*****************************************************/
u8 FT6336_CheckAck(void)							
{
	u8 ucErrTime=0;
	u8 redata;
	
	FT6336_SDA_H();
//	delay_us(5);  
	SDA_IN();  //SDAΪ
	FT6336_SCL_H();			//ʹSDAЧ;SCLСߵƽ:0.6us
	delay_us(10);
	while(Is_SDA_IN != 0)
	{	
		ucErrTime++;
		if(ucErrTime>250)		//Ӧ
		{
			I2C_End();	
			return 1;
		}
	}
	FT6336_SCL_L();
	delay_us(10);
//	SDA_IN();
//	FT6336_SDA_H();
	return 0;
	
}

/****************************************************
*  
*      ƬIIC߷1Bĵַ/
* ڲ ͵1Bַ/
* ز 
* ע һݷ͹;˳ǴӸߵ
*****************************************************/
void FT6336_WrOneByte(u8 dat)						
{
	u8 i;						
	SDA_OUT();     				//sda	
	FT6336_SCL_L();				//ʱӿʼݴ
	for(i = 0; i < 8; i++)		//8λ1Bַ/ݵĳ
	{
		if(dat & 0x80) 		
			FT6336_SDA_H();		//"1"		
		else
			FT6336_SDA_L();		//"0"
		
		delay_us(10);
		FT6336_SCL_H();			//ʹSDAϵЧ
		delay_us(10);			//SCLСߵƽ:0.6us							
		FT6336_SCL_L();			//SCLС͵ƽ:1.2us
		delay_us(10);
		dat <<= 1;				//1λ,Ϊλ׼	
	}
}

/****************************************************
*  
*      ƬIIC߽1B
* ڲ 
* ز յ1B
* ע һݽչ;Ӹߵ͵˳
*****************************************************/
u8 FT6336_RdOneByte(void)						
{
	u8 i,dat = 0;				//λݴ浥Ԫ

	SDA_IN();						//SDAΪ
	for(i = 0;i < 8;i++)
	{
		FT6336_SCL_L();
		delay_us(10);
		FT6336_SCL_H();
		delay_us(10);			//SCLС͵ƽ:1.2us
		dat <<= 1;
		if(Is_SDA_IN != 0)
			dat |= 0x01;
		delay_us(5);			//SCLС͵ƽ:1.2us
	}
//	delay_us(2);
//	FT6336_SDA_H();		
	return(dat);				//1B
	
}
/****************************************************
* FT6336дһ
* reg:ʼĴַ
* buf:ݻ
* len:дݳ
* ֵ:0,ɹ;1,ʧ.
*****************************************************/
u8 FT6336_WR_Reg(u8 reg,u8 *buf,u8 len)
{
	u8 i;
	u8 ret=0;
	I2C_Start();	 
	FT6336_WrOneByte(FT_CMD_WR);	//д 	 
	FT6336_CheckAck(); 	 										  		   
	FT6336_WrOneByte(reg);   	//͵8λַ
	FT6336_CheckAck();  
	for(i=0;i<len;i++)
	{	   
		FT6336_WrOneByte(buf[i]);  	//
		ret=FT6336_CheckAck();
		if(ret)break;  
	}
    I2C_End();					//һֹͣ	    
	return ret; 
	

}
/*****************************************************
* FT6336һ
* reg:ʼĴַ
* buf:ݻ
* len:ݳ
*****************************************************/
void FT6336_RD_Reg(u8 reg,u8 *buf,u8 len)
{
	u8 i; 
 	I2C_Start();	
 	FT6336_WrOneByte(FT_CMD_WR);   	//д 	 
	FT6336_CheckAck(); 	 										  		   
 	FT6336_WrOneByte(reg);   	//͵8λַ
	FT6336_CheckAck();  
//  I2C_End();					//һֹͣ	 
 	I2C_Start();  	 	   
	FT6336_WrOneByte(FT_CMD_RD);   	//Ͷ		   
	FT6336_CheckAck();	  
	for(i=0;i<(len-1);i++)
	{	   
		buf[i] = FT6336_RdOneByte();		//1Bݵݻ
		FT6336_McuACK();					//Ӧλ	  
	}
	buf[i]  = FT6336_RdOneByte();	
	FT6336_McuNACK();						//nֽڶ,ͷӦλ
  I2C_End();					//һֹͣ	  

} 
 



void FT6336U_start(void)
{
	SDA_OUT();     //sda???
	FT6336_SDA_H();	  	  
	FT6336_SCL_H();
	delay_us(10);   //8???,5us??,16???,???????,????8us,????????10us
 	FT6336_SDA_L();//START:when i2c is high,DATA change form high to low 
	delay_us(10);
	FT6336_SCL_L();//??I2C??,????????? 
}

void FT6336U_end(void)
{
	SDA_OUT();//sda???
	FT6336_SCL_L();
	FT6336_SDA_L();//STOP:when i2c is high DATA change form low to high
 	delay_us(10);
	FT6336_SCL_H(); 
	FT6336_SDA_H();//??I2C??????
	delay_us(10);							   	
}

void i2c_write_byte(unsigned char txd)
{			   	
	u8 t,i2c_sda;   
	SDA_OUT(); 	    
	FT6336_SCL_L();//ʱӿʼݴ
	for(t=0;t<8;t++)
	{              
//		i2c_sda=(txd&0x80)>>7;
 
		if(txd&0x80)
			FT6336_SDA_H();
		else 
			FT6336_SDA_L();
		
		txd<<=1; 	
		
		delay_us(10);   //TEA5767ʱǱ
		FT6336_SCL_H();
		delay_us(10); 
		FT6336_SCL_L();	
		delay_us(10);
	}	      
	FT6336_SDA_H();
	delay_us(10);
	SDA_IN();	   
	FT6336_SCL_H();
	delay_us(10);			 
	//	while(Is_SDA_IN);
	for(t=0;t<100;t++)//ʱ100usȴ
	{
		if(Is_SDA_IN != 0)
			delay_us(1);
		else
			break;
	}
	FT6336_SCL_L();

	//----------------------------ʾ--------------------
	if(t >= 100)
	//string_normal(DIS_COL_BOUNDARY+1,UP_START+1,Red,"I2C_NCPL ERROR!");
	;
}

unsigned char i2c_read_byte(void)    //MCUӦ
{
	unsigned char i,receive=0;
	
	SDA_IN();//SDAΪ
	for(i=0;i<8;i++ )
	{
		FT6336_SCL_L(); 
		delay_us(10);
		FT6336_SCL_H();
		receive<<=1;
		if(Is_SDA_IN != 0) 
			receive |= 0x01;   
		delay_us(10); 
	}					 

	FT6336_SCL_L();
	SDA_OUT();
	FT6336_SDA_H();
	delay_us(10);
	FT6336_SCL_H();
	delay_us(10);
	FT6336_SCL_L();

	FT6336_SDA_H();  
	return receive;

}

unsigned char i2c_read_keep_byte(void)    //MCUӦ
{
	unsigned char i,receive=0;
	
	SDA_IN();//SDAΪ
	for(i=0;i<8;i++ )
	{
		FT6336_SCL_L(); 
		delay_us(10);
		FT6336_SCL_H();
		receive<<=1;
		if(Is_SDA_IN != 0) 
			receive |= 0x01;   
		delay_us(10); 
	}					 

	FT6336_SCL_L();
	SDA_OUT();
	FT6336_SDA_L();
	delay_us(10);
	FT6336_SCL_H();
	delay_us(10);
	FT6336_SCL_L();

	FT6336_SDA_H();  
	return receive;
}

unsigned char i2c_read_addr_byte(unsigned char device_addr,unsigned char read_addr)
{
	unsigned char dat;
	FT6336U_start();
	i2c_write_byte(device_addr<<1);
	i2c_write_byte(read_addr);
	FT6336U_end();

	FT6336U_start();
	i2c_write_byte((device_addr<<1) | 0x01);
	dat=i2c_read_byte();
	FT6336U_end();
	return(dat);
}

void i2c_read_addr_str(unsigned char device_addr,unsigned char read_addr,unsigned char read_amount,unsigned char *read_buf)
{
//	uchar dat;
	unsigned char i;
	FT6336U_start();
	i2c_write_byte(device_addr<<1);
	i2c_write_byte(read_addr);
	FT6336U_end();

	FT6336U_start();
	i2c_write_byte((device_addr<<1) | 0x01);

	for(i=0;i<read_amount-1;i++)
	{
		read_buf[i] = i2c_read_keep_byte();	
	}
	read_buf[i] = i2c_read_byte();
	FT6336U_end();
}


void i2c_write_addr_byte(unsigned char device_addr,unsigned char write_addr,unsigned char write_dat)
{
	FT6336U_start();
	i2c_write_byte(device_addr<<1);
	i2c_write_byte(write_addr);
	i2c_write_byte(write_dat);
	FT6336U_end();
	delay_ms(2);
}

unsigned int i2c_read_addr_int(unsigned char device_addr,unsigned char read_addr)
{
	unsigned char read_buf[2];
	i2c_read_addr_str(device_addr,read_addr,2,read_buf);
	return (read_buf[0]<<8)|read_buf[1];
}

void i2c_write_addr_str(unsigned char device_addr,unsigned char write_addr,unsigned char write_amount,unsigned char *write_buf)
{
	unsigned char i;
	FT6336U_start();
	i2c_write_byte(device_addr<<1);
	i2c_write_byte(write_addr);
	for(i=0;i<write_amount;i++)
	{
		i2c_write_byte(write_buf[i]);
	}
	FT6336U_end();
	delay_ms(2);
}
