#include "stm32f10x.h"
#include "Display_EPD_W21_spi.h"
#include "Display_EPD_W21.h"
#include "Ap_29demo.h"	

ErrorStatus HSEStartUpStatus;
unsigned char k=2;

/* Private function prototypes -----------------------------------------------*/
void RCC_Configuration(void);
void NVIC_Configuration(void);
void GPIO_Configuration(void);


void EPD_display_init(void);//EPD init 
void EPD_full_display_clearing(void);//Clear screen after power on
void EPD_full_display(const unsigned char *old_data,const unsigned char *new_data,unsigned char mode);// mode0:Clear,mode1:Refresh picture
void partial_display(u16 x_start,u16 x_end,u16 y_start,u16 y_end ,const unsigned char *old_data,const unsigned char *new_data,unsigned char mode); //partial display
void lut(void);
void lut1(void);
void lcd_chkstatus(void);
void EPD_deep_sleep(void); //Enter deep sleep mode



void driver_delay_us(unsigned int xus)
{
	for(;xus>1;xus--);
}

void driver_delay_xms(unsigned long xms)	
{	
    unsigned long i = 0 , j=0;

    for(j=0;j<xms;j++)
	{
        for(i=0; i<256; i++);
    }
}


/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
#define NVIC_VectTab_FLASH  misc.h
*******************************************************************************/

int	main(void)
{
	RCC_Configuration();
	//GPIO config
	GPIO_Configuration();
		 	/******Clear screen after power on*****/
  EPD_display_init(); //EPD init
	EPD_full_display_clearing(); //Clear screen after power on
  EPD_deep_sleep(); //Enter deep sleep mode,This step is a must

	EPD_display_init(); //EPD init
	EPD_full_display(gImage_1,gImage_1,0); //pic1
	EPD_deep_sleep(); //Enter deep sleep mode,This step is a must
	driver_delay_xms(50000);

	EPD_display_init(); //EPD init
	EPD_full_display(gImage_1,gImage_2,1); //pic2
	EPD_deep_sleep();//Enter deep sleep mode,This step is a must
	driver_delay_xms(50000);
																																																					
	EPD_display_init(); //EPD init
	EPD_full_display(gImage_2,gImage_3,1); //pic3
	EPD_deep_sleep(); //Enter deep sleep mode,This step is a must
	driver_delay_xms(50000);

			/******End screen clearing*****/
	EPD_display_init(); //EPD init
	EPD_full_display(gImage_3,gImage_3,2); //End screen clearing

//(Perform a full-screen refresh operation after 5 partial refreshes, otherwise the residual image may not be removed.)	
//////////////////////////partial display 0~9////////////////////////////////////////////	
	
	partial_display(0,32,0,64, gImage_num1,gImage_num1,0); //partial display 0 1                             
	partial_display(0,32,0,64, gImage_num1,gImage_num2,1); //partial display 1 2                         //////////////x,y   ----Y----
	partial_display(0,32,0,64, gImage_num2,gImage_num3,1); //partial display 1 2                         //////////////x,y   ----Y----
	partial_display(0,32,0,64, gImage_num3,gImage_num4,1); //partial display 1 2                         //////////////x,y   ----Y----
	partial_display(0,32,0,64, gImage_num4,gImage_num5,1); //partial display 1 2                         //////////////x,y   ----Y----



	/******Clear screen after Partial refresh*****/
  EPD_display_init(); //EPD init
	EPD_full_display_clearing(); //Clear screen after power on
  EPD_deep_sleep(); //Enter deep sleep mode,This step is a must
	while(1);
 }


 
 

 
 
 //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////extern function/////////////////////////////////////////////////////////////////////////////////////////////////////////////



/*************************EPD display init function******************************************************/
void EPD_display_init(void)
{
	  EPD_W21_Init();
	  driver_delay_xms(100);					//reset IC and select BUS 

		EPD_W21_WriteCMD(0x00);        			//panel setting
    EPD_W21_WriteDATA (0xff);
		EPD_W21_WriteDATA (0x0e);	

		EPD_W21_WriteCMD(0x01);				 
		EPD_W21_WriteDATA(0x03);
		EPD_W21_WriteDATA(0x06);//16V
		EPD_W21_WriteDATA(0x2A);//
		EPD_W21_WriteDATA(0x2A);//
	
		EPD_W21_WriteCMD(0x4D);        			//FITIinternal code
    EPD_W21_WriteDATA (0x55);

		EPD_W21_WriteCMD(0xaa);        			
    EPD_W21_WriteDATA (0x0f);
		
		EPD_W21_WriteCMD(0xE9);        			
    EPD_W21_WriteDATA (0x02);

		EPD_W21_WriteCMD(0xb6);        			
    EPD_W21_WriteDATA (0x11);
		
		EPD_W21_WriteCMD(0xF3);        			
    EPD_W21_WriteDATA (0x0a);     

		EPD_W21_WriteCMD(0x06);        		 //boost soft start
    EPD_W21_WriteDATA (0xc7);
		EPD_W21_WriteDATA (0x0c);
		EPD_W21_WriteDATA (0x0c);		
		
		EPD_W21_WriteCMD(0x61);			//resolution setting
    EPD_W21_WriteDATA (0xc8); //200
		EPD_W21_WriteDATA (0x00);		
    EPD_W21_WriteDATA (0xc8);  //200     

		EPD_W21_WriteCMD(0x60);        	 //Tcon setting		
    EPD_W21_WriteDATA (0x00);
		

	

		EPD_W21_WriteCMD(0x82);           
    EPD_W21_WriteDATA (0x12);

		EPD_W21_WriteCMD(0x30);         
    EPD_W21_WriteDATA (0x3C);

		EPD_W21_WriteCMD(0X50);						
		EPD_W21_WriteDATA(0x97);//
		
	  EPD_W21_WriteCMD(0XE3);						
		EPD_W21_WriteDATA(0x00);
  	lut();		
			
	}
/***************************full display function*************************************/
	void EPD_full_display_clearing(void)//Clear the screen for the first time
	{
		unsigned int i,j;

		
		for(j=0;j<2;j++)
		{
			EPD_W21_WriteCMD(0x10);
			for(i=0;i<5000;i++)	     
			{
					EPD_W21_WriteDATA(0x00);  
			}  
			driver_delay_xms(2);
		  EPD_W21_WriteCMD(0x13);
			for(i=0;i<5000;i++)	     
			{
					EPD_W21_WriteDATA(0xff);  
			}  
			driver_delay_xms(2);

			EPD_W21_WriteCMD(0x04);//Power on
			driver_delay_xms(100);
			lcd_chkstatus();			
			EPD_W21_WriteCMD(0x12);			//DISPLAY REFRESH 	
			driver_delay_xms(100);	    //!!!The delay here is necessary, 200uS at least!!!     
			lcd_chkstatus();	
		}
 }		
	
	void EPD_full_display(const unsigned char *old_data,const unsigned char *new_data,unsigned char mode)// mode0:Refresh picture1,mode1:Refresh picture2... ,mode2:Clear
{		
		unsigned int i;
		
    if(mode==0)  //mode0:Refresh picture1
		{
			EPD_W21_WriteCMD(0x10);
			for(i=0;i<5000;i++)	     
			{
					EPD_W21_WriteDATA(0xff);  
			}  
			driver_delay_xms(2);
		  EPD_W21_WriteCMD(0x13);
			for(i=0;i<5000;i++)	     
			{
					EPD_W21_WriteDATA(new_data[i]);  
			}  
			driver_delay_xms(2);
	  }
		
		else if(mode==1)  //mode0:Refresh picture2...
		{
			EPD_W21_WriteCMD(0x10);
			for(i=0;i<5000;i++)	     
			{
					EPD_W21_WriteDATA(old_data[i]);  
			}  
			driver_delay_xms(2);
		  EPD_W21_WriteCMD(0x13);
			for(i=0;i<5000;i++)	     
			{
					EPD_W21_WriteDATA(new_data[i]);  
			}  
			driver_delay_xms(2);
	  }
		
   else 
		{
		  EPD_W21_WriteCMD(0x10);
			for(i=0;i<5000;i++)	     
			{
					EPD_W21_WriteDATA(old_data[i]);  
			}  
			driver_delay_xms(2);
			EPD_W21_WriteCMD(0x13);
			for(i=0;i<5000;i++)	     
			{
					EPD_W21_WriteDATA(0xff);  
			}  
			driver_delay_xms(2);
	  }	 

	
	  EPD_W21_WriteCMD(0x04);//Power on
		driver_delay_xms(100);
		lcd_chkstatus();
	
		EPD_W21_WriteCMD(0x12);			//DISPLAY REFRESH 	
		driver_delay_xms(100);	    //!!!The delay here is necessary, 200uS at least!!!     
		lcd_chkstatus();
}

/***************************partial display function*************************************/

void partial_display(u16 x_start,u16 x_end,u16 y_start,u16 y_end ,const unsigned char *old_data,const unsigned char *new_data,unsigned char mode) //partial display
{
	  unsigned datas,i;
		EPD_W21_WriteCMD(0X50);
		EPD_W21_WriteDATA(0x97);	    
		lut1();
	
	  EPD_W21_WriteCMD(0x91);		//This command makes the display enter partial mode
		EPD_W21_WriteCMD(0x90);		//resolution setting
		EPD_W21_WriteDATA (x_start);   //x-start     
		EPD_W21_WriteDATA (x_end-1);	 //x-end	
	  EPD_W21_WriteDATA (0);	 //x Reserved	

		EPD_W21_WriteDATA (y_start);   //y-start    
    EPD_W21_WriteDATA (0);	 //y Reserved		
		EPD_W21_WriteDATA (y_end);	 //y-end	
		EPD_W21_WriteDATA (0x01);	
    datas=(x_end-x_start)*(y_end-y_start)/8;
		
		EPD_W21_WriteCMD(0x10);	       //writes Old data to SRAM for programming
		if(mode==0)
		{
			for(i=0;i<datas;i++)	     
			{
				EPD_W21_WriteDATA(0xff);  
			} 			
		}
		else
		{
			for(i=0;i<datas;i++)	     
			{
				EPD_W21_WriteDATA(old_data[i]);  
			} 
	  }
		EPD_W21_WriteCMD(0x13);				 //writes New data to SRAM.
		for(i=0;i<datas;i++)	     
		{
			EPD_W21_WriteDATA(new_data[i]);  
		} 
    	
		EPD_W21_WriteCMD(0x12);		 //DISPLAY REFRESH 		             
		driver_delay_xms(100);     //!!!The delay here is necessary, 200uS at least!!!     
		lcd_chkstatus();
  
}
/////////////////////////////Enter deep sleep mode////////////////////////
void EPD_deep_sleep(void) //Enter deep sleep mode
{
		EPD_W21_WriteCMD(0X50);
		EPD_W21_WriteDATA(0xf7);	
		EPD_W21_WriteCMD(0X02);  	//power off
	 driver_delay_xms(100);
	  lcd_chkstatus();
		EPD_W21_WriteCMD(0X07);  	//deep sleep
		EPD_W21_WriteDATA(0xA5);
	  	driver_delay_xms(3000);
}

//LUT download
void lut(void)
{
	unsigned int count;
	EPD_W21_WriteCMD(0x20);
	for(count=0;count<42;count++)	     
		{EPD_W21_WriteDATA(lut_vcomDC[count]);}

	EPD_W21_WriteCMD(0x21);
	for(count=0;count<42;count++)	     
		{EPD_W21_WriteDATA(lut_ww[count]);}   
	
	EPD_W21_WriteCMD(0x22);
	for(count=0;count<42;count++)	     
		{EPD_W21_WriteDATA(lut_bw[count]);} 

	EPD_W21_WriteCMD(0x23);
	for(count=0;count<42;count++)	     
		{EPD_W21_WriteDATA(lut_wb[count]);} 

	EPD_W21_WriteCMD(0x24);
	for(count=0;count<42;count++)	     
		{EPD_W21_WriteDATA(lut_bb[count]);} 
}

void lut1(void)
{
	unsigned int count;
	EPD_W21_WriteCMD(0x20);
	for(count=0;count<42;count++)	     
		{EPD_W21_WriteDATA(lut_vcomDC1[count]);}

	EPD_W21_WriteCMD(0x21);
	for(count=0;count<42;count++)	     
		{EPD_W21_WriteDATA(lut_ww1[count]);}   
	
	EPD_W21_WriteCMD(0x22);
	for(count=0;count<42;count++)	     
		{EPD_W21_WriteDATA(lut_bw1[count]);} 

	EPD_W21_WriteCMD(0x23);
	for(count=0;count<42;count++)	     
		{EPD_W21_WriteDATA(lut_wb1[count]);} 

	EPD_W21_WriteCMD(0x24);
	for(count=0;count<42;count++)	     
		{EPD_W21_WriteDATA(lut_bb1[count]);}   
}


void lcd_chkstatus(void)
{
	while(!isEPD_W21_BUSY);   
                       
}
/***********************************************************
						end file
***********************************************************/

/*******************************************************************************
* Function Name  : RCC_Configuration
* Description    : Configures the different system clocks.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RCC_Configuration(void)
{
 
  // λRCCʱ(ڵģʽ) 
  RCC_DeInit();
 
  // ʹⲿ 
  RCC_HSEConfig(RCC_HSE_ON);
  
  // ȴⲿȶ 
  HSEStartUpStatus = RCC_WaitForHSEStartUp();
  if(HSEStartUpStatus == SUCCESS)
  {
    // ໷ƵPLLCLK = 8MHz * 9 = 72 MHz 
    RCC_PLLConfig(RCC_PLLSource_HSE_Div1, RCC_PLLMul_9);
  }
  else {
    // ʹڲ 
    RCC_HSICmd(ENABLE);
    // ȴȶ 
    while(RCC_GetFlagStatus(RCC_FLAG_HSIRDY) == RESET);

    // ໷ƵPLLCLK = 8MHz/2 * 16 = 64 MHz 
    RCC_PLLConfig(RCC_PLLSource_HSI_Div2,RCC_PLLMul_16);
  }

    // ʹFLASHԤȡ 
  FLASH_PrefetchBufferCmd(FLASH_PrefetchBuffer_Enable);

  //ôʱֵ,FLASH_Latency_2Ϊʱ
  FLASH_SetLatency(FLASH_Latency_2);
	
  //ϵͳʱ
  RCC_HCLKConfig(RCC_SYSCLK_Div1); 

  //ø豸ʱӣRCC_HCLK_Div1Ϊϵͳʱӳ1
  RCC_PCLK2Config(RCC_HCLK_Div1); 

  //õ豸ʱӣRCC_HCLK_Div2Ϊϵͳʱӳ2
  RCC_PCLK1Config(RCC_HCLK_Div2);
  
  //ʹ໷Ƶ
  RCC_PLLCmd(ENABLE);
  
  // ȴ໷ƵƵȶ 
  while(RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET);
  
  // ѡ໷ʱΪϵͳʱԴ 
  RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);
  
  // ȴ 
  while(RCC_GetSYSCLKSource() != 0x08);
    
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA |
            RCC_APB2Periph_USART1|RCC_APB2Periph_AFIO,
            ENABLE);

}

/*******************************************************************************
*    : GPIO_Configuration
*          : ôGPIOŵĲ
*          : None
*          : None
*          : None
*******************************************************************************/
void GPIO_Configuration(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;

  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOD, ENABLE);
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8 | GPIO_Pin_9 |GPIO_Pin_10;    //abcd OE ST LT0
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOD, &GPIO_InitStructure);

  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOE, ENABLE);
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_11 | GPIO_Pin_14 |GPIO_Pin_15;    //abcd OE ST LT0
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOE, &GPIO_InitStructure);

  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_13;    //abcd OE ST LT0
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  GPIO_Init(GPIOE, &GPIO_InitStructure);
	
	//LEDƹ
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_12;    //LED
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOE, &GPIO_InitStructure);
	GPIO_SetBits(GPIOE,GPIO_Pin_5); 						 //PE.5  
}

/*******************************************************************************
* Function Name  : NVIC_Configuration
* Description    : Configures Vector Table base location.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void NVIC_Configuration(void)
{ 
  //NVIC_InitTypeDef NVIC_InitStructure;
  ;
}


#ifdef  DEBUG
/*******************************************************************************
* Function Name  : assert_failed
* Description    : Reports the name of the source file and the source line number
*                  where the assert_param error has occurred.
* Input          : - file: pointer to the source file name
*                  - line: assert_param error line source number
* Output         : None
* Return         : None
*******************************************************************************/
void assert_failed(u8* file, u32 line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif






