#include "stm32f10x.h"
#include "Display_EPD_W21_spi.h"
#include "Display_EPD_W21.h"
#include "Ap_29demo.h"	

ErrorStatus HSEStartUpStatus;

/* Private function prototypes -----------------------------------------------*/
void RCC_Configuration(void);
void NVIC_Configuration(void);
void GPIO_Configuration(void);

//EPD
void Full_lut_bw(void);
void Part_lut_bw(void);
void Full_updata_setting(void);
void Part_updata_setting(void);
void Full_image(const unsigned char *data);
void Part_image(const unsigned char *data_old,const unsigned char *data_new);
void Part_image_first(const unsigned char *data_new);
void Updata(void);
void lcd_chkstatus(void);
void Full_image_Clean(void);
void driver_delay_us(unsigned int xus)  //1us
{
	for(;xus>1;xus--);
}

void driver_delay_xms(unsigned long xms) //1ms
{	
    unsigned long i = 0 , j=0;

    for(j=0;j<xms;j++)
	{
        for(i=0; i<256; i++);
    }
}
void DELAY_S(unsigned int delaytime)     //  1s
{
	int i,j,k;
	for(i=0;i<delaytime;i++)
  {
		for(j=0;j<4000;j++)           
		{
			for(k=0;k<222;k++);
                
		}
	}
}
void DELAY_M(unsigned int delaytime)     //  1M
{
	int i;
	for(i=0;i<delaytime;i++)
		DELAY_S(60);
}
/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
#define NVIC_VectTab_FLASH  misc.h
*******************************************************************************/

//Tips//
/*When the electronic paper is refreshed in full screen, the picture flicker is a normal phenomenon, and the main function is to clear the display afterimage in the previous picture.
  When the local refresh is performed, the screen does not flash.*/
/*When you need to transplant the driver, you only need to change the corresponding IO. The BUSY pin is the input mode and the others are the output mode. */

int	main(void)
{
	RCC_Configuration();
	//GPIO settings
	GPIO_Configuration();

	while(1)	   
	{
		//Full
		Full_updata_setting();//EPD init
		Full_image(gImage_1);
		DELAY_S(25);
		//Clean
		Full_image_Clean();//Clean screen
		DELAY_S(10);
		//Part
		Part_updata_setting();//EPD init
		Part_image_first(gImage_2);		  //Part_image1 
		DELAY_S(15);
		Part_image(gImage_2,gImage_3);  //Part_image2
		DELAY_S(15);

		Part_image(gImage_3,gImage_4);	//Part_image3 
		DELAY_S(25);
		
    //Clean
		Full_updata_setting();//EPD init
    Full_image_Clean();//Clean screen
		DELAY_S(25);	
		while(1);
	}
}	
	




void Full_updata_setting(void)
{
    EPD_W21_Init(); //Electronic paper IC reset
	
	EPD_W21_WriteCMD(0xD2);			
	EPD_W21_WriteDATA(0x3F);
						 
	EPD_W21_WriteCMD(0x00);  			
	EPD_W21_WriteDATA (0x6F);  //from outside

	EPD_W21_WriteCMD(0x01);  			//power setting
	EPD_W21_WriteDATA (0x03);	    
	EPD_W21_WriteDATA (0x00);
	EPD_W21_WriteDATA (0x2b);		
	EPD_W21_WriteDATA (0x2b); 
	
	EPD_W21_WriteCMD(0x06);				
	EPD_W21_WriteDATA(0x3f);
	
	EPD_W21_WriteCMD(0x2A);			
	EPD_W21_WriteDATA(0x00); 
	EPD_W21_WriteDATA(0x00); 
	
	EPD_W21_WriteCMD(0x30);	
	EPD_W21_WriteDATA(0x13); 

	EPD_W21_WriteCMD(0x50);
	EPD_W21_WriteDATA(0x57);			

	EPD_W21_WriteCMD(0x60);			
	EPD_W21_WriteDATA(0x22);

	EPD_W21_WriteCMD(0x61);			//resolution setting
  EPD_W21_WriteDATA (0x50);       //source 128 	 
  EPD_W21_WriteDATA (0x80);       

	EPD_W21_WriteCMD(0x82);			
	EPD_W21_WriteDATA(0x12);  //-1v

	EPD_W21_WriteCMD(0xe3);			
	EPD_W21_WriteDATA(0x33);

	Full_lut_bw();	//Load waveform file		    		
}


void Part_updata_setting(void)
{
	EPD_W21_Init();
	EPD_W21_WriteCMD(0xD2); //Factory setting parameters			
	EPD_W21_WriteDATA(0x3F);
						 
	EPD_W21_WriteCMD(0x00);  			
	EPD_W21_WriteDATA (0x6F);  //from outside


	EPD_W21_WriteCMD(0x01);  			//power setting
	EPD_W21_WriteDATA (0x03);	    
	EPD_W21_WriteDATA (0x00);
	EPD_W21_WriteDATA (0x2b);		
	EPD_W21_WriteDATA (0x2b); 
	
	EPD_W21_WriteCMD(0x06);				
	EPD_W21_WriteDATA(0x3f);
	
	EPD_W21_WriteCMD(0x2A);			
	EPD_W21_WriteDATA(0x00); 
	EPD_W21_WriteDATA(0x00); 
	
	EPD_W21_WriteCMD(0x30); //PLL
	EPD_W21_WriteDATA(0x05);
				
	EPD_W21_WriteCMD(0x50);	//VCOM AND DATA INTERVAL SETTING				
	EPD_W21_WriteDATA(0xF2);

	EPD_W21_WriteCMD(0x60);			
	EPD_W21_WriteDATA(0x22);

	EPD_W21_WriteCMD(0x82);		//VCOM	
  EPD_W21_WriteDATA(0x00);//-0.1v

	EPD_W21_WriteCMD(0xe3);			
	EPD_W21_WriteDATA(0x33);

	Part_lut_bw();//Load waveform file		
}

void Updata(void)
{
    EPD_W21_WriteCMD(0x04);     		//power on
		lcd_chkstatus();
		EPD_W21_WriteCMD(0x12);	
		lcd_chkstatus();
		EPD_W21_WriteCMD(0x02);
		lcd_chkstatus();
}
void Full_image(const unsigned char *data)
{
	  unsigned int i;
		EPD_W21_WriteCMD(0x10);
		for(i=0;i<1280;i++)
		{
			EPD_W21_WriteDATA(0xff);
		}
		EPD_W21_WriteCMD(0x13);	      //Transfer new data
		for(i=0;i<1280;i++)
		{
			EPD_W21_WriteDATA(*data);
			data++;
		}
	Updata();
			 		
}	
void Full_image_Clean(void)
{ 
	  unsigned int i;
		EPD_W21_WriteCMD(0x10);
		for(i=0;i<1280;i++)
		{
			EPD_W21_WriteDATA(0xff);
		}
		EPD_W21_WriteCMD(0x13);	       //Transfer new data
		for(i=0;i<1280;i++)
		{
			EPD_W21_WriteDATA(0xff);
		}
	Updata();
			 		
}
void Part_image(const unsigned char *data_old,const unsigned char *data_new)
{
	unsigned int i;
	EPD_W21_WriteCMD(0x91);			//resolution setting
	EPD_W21_WriteCMD(0x90);			//resolution setting
	EPD_W21_WriteDATA (0);       	 
	EPD_W21_WriteDATA (79);		
	EPD_W21_WriteDATA (0);
	EPD_W21_WriteDATA (127);
	EPD_W21_WriteDATA (0x00);

 
	EPD_W21_WriteCMD(0x10);
	for(i=0;i<1280;i++)
	{
		EPD_W21_WriteDATA(*data_old);
		data_old++;
	}
	EPD_W21_WriteCMD(0x13);	       //Transfer new data
	for(i=0;i<1280;i++)
	{
		EPD_W21_WriteDATA(*data_new);
		data_new++;
	}
 Updata();
	
}
void Part_image_first(const unsigned char *data_new)
{
	unsigned int i;
	EPD_W21_WriteCMD(0x91);			//resolution setting
	EPD_W21_WriteCMD(0x90);			//resolution setting
	EPD_W21_WriteDATA (0);       	 
	EPD_W21_WriteDATA (79);		
	EPD_W21_WriteDATA (0);
	EPD_W21_WriteDATA (127);
	EPD_W21_WriteDATA (0x00);

 
	EPD_W21_WriteCMD(0x10);
	for(i=0;i<1280;i++)
	{
		EPD_W21_WriteDATA(0xff);
	}
	EPD_W21_WriteCMD(0x13);	         //Transfer new data
	for(i=0;i<1280;i++)
	{
		EPD_W21_WriteDATA(*data_new);
		data_new++;
	}
 Updata();
	
}
void Full_lut_bw(void)
{
	unsigned int count;
	EPD_W21_WriteCMD(0x23);
	for(count=0;count<42;count++)	     
	{EPD_W21_WriteDATA(lut_w1[count]);}    
	
	EPD_W21_WriteCMD(0x24);
	for(count=0;count<42;count++)	     
	{EPD_W21_WriteDATA(lut_b1[count]);}          
}

void Part_lut_bw(void)
{
	unsigned int count;
	EPD_W21_WriteCMD(0x23);
	for(count=0;count<42;count++)	     
	{EPD_W21_WriteDATA(lut_w[count]);}    
	
	EPD_W21_WriteCMD(0x24);
	for(count=0;count<42;count++)	     
	{EPD_W21_WriteDATA(lut_b[count]);}          
}







	





void lcd_chkstatus(void)
{
	unsigned char busy;
	do
	{
		EPD_W21_WriteCMD(0x71);
		busy = isEPD_W21_BUSY;
		busy =!(busy & 0x01);        
	}
	while(busy);   
	driver_delay_xms(200);                       
}
/*******************************************************************************
* Function Name  : RCC_Configuration
* Description    : Configures the different system clocks.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RCC_Configuration(void)
{
 
  // Reset RCC clock configuration
  RCC_DeInit();
 
  // Enable external crystal
  RCC_HSEConfig(RCC_HSE_ON);
  
  // Waiting for the external crystal to stabilize
  HSEStartUpStatus = RCC_WaitForHSEStartUp();
  if(HSEStartUpStatus == SUCCESS)
  {
    // Set the phase-locked loop frequency PLLCLK = 8MHz * 9 = 72 MHz
    RCC_PLLConfig(RCC_PLLSource_HSE_Div1, RCC_PLLMul_9);
  }
  else {
    // Enable internal crystal
    RCC_HSICmd(ENABLE);
    // Waiting for the internal crystal to stabilize
    while(RCC_GetFlagStatus(RCC_FLAG_HSIRDY) == RESET);

    // Set the phase-locked loop frequency PLLCLK = 8MHz/2 * 16 = 64 MHz 
    RCC_PLLConfig(RCC_PLLSource_HSI_Div2,RCC_PLLMul_16);
  }

    // Enable flash prefetch cache
  FLASH_PrefetchBufferCmd(FLASH_PrefetchBuffer_Enable);

  //Set the code delay, FLASH_Latency_2 is two delay cycles
  FLASH_SetLatency(FLASH_Latency_2);
	
  //Set the system total clock
  RCC_HCLKConfig(RCC_SYSCLK_Div1); 

  //Set the high speed device total clock, RCC_HCLK_Div1 is the system clock divided by 1
  RCC_PCLK2Config(RCC_HCLK_Div1); 

  //Set the low speed device total clock, RCC_HCLK_Div2 is the system clock divided by 2
  RCC_PCLK1Config(RCC_HCLK_Div2);
  
  //Enable phase-locked loop multiplier
  RCC_PLLCmd(ENABLE);
  
  // Waiting for the frequency of the phase-locked loop to multiply after frequency stabilization
  while(RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET);
  
  // Select the phase-locked loop clock as the system clock
  RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);
  
  // Waiting for setup to complete
  while(RCC_GetSYSCLKSource() != 0x08);
    
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA |
            RCC_APB2Periph_USART1|RCC_APB2Periph_AFIO,
            ENABLE);

}

/*******************************************************************************
* Function name  : GPIO_Configuration
* Description         : Set the GPIO pin parameters used by the SPI serial port.
* Input        : None
* Output        : None
* Return         : None
*******************************************************************************/
void GPIO_Configuration(void)
{
	GPIO_InitTypeDef  GPIO_InitStructure;
 	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOD|RCC_APB2Periph_GPIOE, ENABLE);
	  				     	
	
	 //CS-->PD8   SCK-->PD9  SDO--->PD10 
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8|GPIO_Pin_9|GPIO_Pin_10;		//Port configuration
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP; 		 			
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;		 		
	GPIO_Init(GPIOD, &GPIO_InitStructure);	  	
	
	
	
	 // D/C--->PE15	   RES-->PE14
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_14|GPIO_Pin_15;		//Port configuration
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP; 		 			
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;		 		
	GPIO_Init(GPIOE, &GPIO_InitStructure);	  				     		
	
	// BUSY--->PE13
	GPIO_InitStructure.GPIO_Pin  = GPIO_Pin_13;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;	//Pull up input
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
 	GPIO_Init(GPIOE, &GPIO_InitStructure);				//Initialize GPIO
	
	 //LED
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_12;		//Port configuration
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP; 		 			
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;		 		
	GPIO_Init(GPIOE, &GPIO_InitStructure);
}
/*******************************************************************************
* Function Name  : NVIC_Configuration
* Description    : Configures Vector Table base location.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void NVIC_Configuration(void)
{ 
  //NVIC_InitTypeDef NVIC_InitStructure;
  ;
}


#ifdef  DEBUG
/*******************************************************************************
* Function Name  : assert_failed
* Description    : Reports the name of the source file and the source line number
*                  where the assert_param error has occurred.
* Input          : - file: pointer to the source file name
*                  - line: assert_param error line source number
* Output         : None
* Return         : None
*******************************************************************************/
void assert_failed(u8* file, u32 line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif






